<?php

class UserStudentIdentity extends CUserIdentity
{
	const ERROR_USER_STATUS_INACTIVE = 3;

	private $id;

	public function authenticate()
	{
		$userModel = Uzytkownik::model()->find('LOWER("email") = :email',
			array(':email'=>strtolower($this->username)));
		$this->errorCode = self::ERROR_NONE;

		if($userModel === null)
			$this->errorCode=self::ERROR_USERNAME_INVALID;
		else if($userModel->status == Uzytkownik::USER_STATUS_INACTIVE)
			$this->errorCode=self::ERROR_USER_STATUS_INACTIVE;
		else if(hash('sha1', $this->password) !== $userModel->haslo)
			$this->errorCode=self::ERROR_PASSWORD_INVALID;
		else
		{
			$this->id = $userModel->id;
			$this->username = $userModel->imie;
			$this->setState('imie', $userModel->imie);
			$this->setState('nazwisko', $userModel->nazwisko);
			$this->setState('id_klasy', $userModel->idKlasy);
			$this->setState('role','student');
			$this->setState('id_firmy', $userModel->idFirmy);
			$this->setState('plec',     $userModel->plec);
			$this->setState('pesel',     $userModel->pesel);

			$this->setState('type', 2);

			$userModel->dataLogowania = new CDbExpression("sysdate");
			$userModel->save(false);
		}

		return !$this->errorCode;
	}

	public function getId()
	{
		return $this->id;
	}

	public function setId($id)
	{
		$this->id = $id;
	}
}
